# [

> Controlla i tipi di file e confronta i valori.
> Restituisce uno stato pari a 0 se la condizione risulta vera, 1 se risulta falsa.
> Vedi anche: `test`.
> Maggiori informazioni: <https://gnu.org/software/bash/manual/bash.html#index-test>.

- Verifica se una determinata variabile è uguale/diversa dalla stringa specificata:

`[ "${{variabile}}" {{=|!=}} "{{stringa}}" ]`

- Verifica se una variabile data è [eq]uguale/[n]on [e]uguale/[g]maggiore [t]di/[l]minore [t]di/[g]maggiore di o [e]uguale/[l]minore di o [e]uguale al numero specificato:

`[ "${{variabile}}" -{{eq|ne|gt|lt|ge|le}} {{intero}} ]`

- Verifica se la variabile specificata ha un valore [n]on-empty:

`[ -n "${{variabile}}" ]`

- Verifica se la variabile specificata ha un valore vuoto:

`[ -z "${{variabile}}" ]`

- Verifica se il [f]ile specificato esiste:

`[ -f {{percorso/del/file}} ]`

- Verifica se la [d]irectory specificata esiste:

`[ -d {{percorso/della/directory}} ]`

- Verifica se la directory o file specificata/o [e]siste:

`[ -e {{percorso/del/file_o_directory}} ]`
